#include <bits/stdc++.h>

using namespace std;
typedef long long ll;
typedef long double ld;

struct Vector {
    ll x, y;

    Vector () {}
    Vector (ll x, ll y): x(x), y(y) {}

    Vector operator-(Vector other) {
        return Vector(x - other.x, y - other.y);
    }

    ll operator*(Vector other) {
        return x * other.x + y * other.y;
    }

    ll operator^(Vector other) {
        return x * other.y - y * other.x;
    }
};

istream& operator>>(istream& is, Vector &vec) {
    return is >> vec.x >> vec.y;
}

struct Segment {
    Vector from, to;
    Segment () {}
};

bool axis_intersects(ll l1, ll r1, ll l2, ll r2) {
    if (l1 > r1) swap(l1 ,r1);
    if (l2 > r2) swap(l2, r2);
    return max(l1, l2) <= min(r1, r2);
}

bool bound_intersects(Segment a, Segment b) {
    return axis_intersects(a.from.x, a.to.x, b.from.x, b.to.x) &&
        axis_intersects(a.from.y, a.to.y, b.from.y, b.to.y);
}

int sign(ll x) {
    if (x > 0)
        return 1;
    if (x < 0)
        return -1;
    return 0;
}

bool intersects(Segment a, Segment b) {
    if (!bound_intersects(a, b))
        return false;

    if (sign((a.to - a.from) ^ (b.from - a.from)) * sign((a.to - a.from) ^ (b.to - a.from)) > 0)
        return false;

    if (sign((b.to - b.from) ^ (a.from - b.from)) * sign((b.to - b.from) ^ (a.to - b.from)) > 0)
        return false;

    if (sign((a.from - a.to) ^ (b.from - a.to)) * sign((a.from - a.to) ^ (b.to - a.to)) > 0)
        return false;

    if (sign((b.from - b.to) ^ (a.from - b.to)) * sign((b.from - b.to) ^ (a.to - b.to)) > 0)
        return false;

    return true;
}

ll dfs(vector <vector <int>> &graph, vector <int> &discovered, int u, int p) {
    discovered[u] = true;

    ll result = 0;
    for (int v: graph[u]) {
        if (v == p)
            continue;

        if (discovered[v]) {
            result++;
            continue;
        }

        result += dfs(graph, discovered, v, u);
    }

    return result;
}

void solve() {
    int n;
    cin >> n;

    vector <Segment> segments(n);
    for (auto &seg: segments)
        cin >> seg.from >> seg.to;

    vector <vector <int>> graph(n);
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < i; j++) {
            if (intersects(segments[i], segments[j])) {
                graph[i].emplace_back(j);
                graph[j].emplace_back(i);
            }
        }
    }

    ll answer = 0;
    vector <int> discovered(n);
    for (int i = 0; i < n; i++) {
        if (discovered[i])
            continue;

        answer += dfs(graph, discovered, i, -1);
    }

    cout << answer / 2 + 1 << '\n';
}

signed main() {
	cin.tie(NULL);
	ios_base::sync_with_stdio(false);

    #ifdef local
    freopen("input", "r", stdin);
	#endif // local

    int t;
    cin >> t;

    while (t--)
	solve();
}
